# Taurus Mover Production Test

import math
import time

Debug = 0
MoveCount = 0

OldPos = None
TravelDist = 0
Cont = True  # Cont nicht mehr nötig durch break Mechanismus in Arnes GUI?
EnSecondTry = 0
NrIterationsGlobal = 1000

from dc.common import logger
from dc.common.logger import Colour
from dc.hci import core


async def _AxisTest(Axis, StartPos, EndPos, Iterations):
    Speed = Axis.settings.MotorSpeed
    Accel = Axis.settings.MotorAcceleration
    NrIterations = Iterations

    logger.info_colour(Colour.LIGHTGREEN, f"Test {type(Axis).__name__} Production Test Start:")
    logger.info(f"StartPos: {StartPos}")
    logger.info(f"EndPos: {EndPos}")
    logger.info(f"Speed: {Speed}")
    logger.info(f"Accel: {Accel}")
    logger.info(f"Nr. of Iterations: {NrIterations}")
    logger.info("\n")

    logger.info("Homing:")
    await Axis.Home()
    #await Axis.MoveAbs(20)    #needed?

    logger.info("Homing finished")


async def _SingleAxisTest(Axis, StartPos, EndPos, MinStepSize, Iterations):
    TotalDist = EndPos - StartPos
    Count1 = math.floor(TotalDist / MinStepSize)
    StepSize = TotalDist / Count1

    if Iterations > 1:
        logger.info(f"TotalDist: {TotalDist} mm")
        logger.info(f"Nr of steps per direction: {Count1}")
        logger.info(f"StepSize: {StepSize} mm")

    Cont = True
    OldPos = StartPos
    idx = 0

    try:
        while idx < Iterations and Cont:
            if Iterations > 1:
                logger.warn(f"iteration {idx + 1}")
            if not Cont:
                await _MoveAxis(Axis, StartPos)

            NewPos = StartPos
            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos + 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos - 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            if Cont:
                await _MoveAxis(Axis, EndPos)
                logger.info("running to EndPos")

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            idx = idx + 1

    except Exception as e:
        logger.error(f"Error occured, Test stopped: {str(e)}")

async def _SingleAxisTestWHoming(Axis, StartPos, EndPos, MinStepSize, Iterations):
    reserved = 0
    
    TotalDist = EndPos - StartPos
    Count1 = math.floor(TotalDist / MinStepSize)
    StepSize = TotalDist / Count1

    if Iterations > 1:
        logger.info(f"TotalDist: {TotalDist} mm")
        logger.info(f"Nr of steps per direction: {Count1}")
        logger.info(f"StepSize: {StepSize} mm")

    Cont = True
    OldPos = StartPos
    idx = 0
    
    reserved1, RefSwitchTolerance, reserved2 = await Axis.GetConfigParam((r"AxisConfig\RefSwitchToleranceUOM", reserved, 0))
    logger.info(f"RefSwitchTolerance: {RefSwitchTolerance} mm")

    try:
        while idx < Iterations and Cont:
            if Iterations > 1:
                logger.info(f"iteration {idx + 1}")
            if not Cont:
                await _MoveAxis(Axis, StartPos)

            NewPos = StartPos
            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos + 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos - 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            if Cont:
                await _MoveAxis(Axis, StartPos)
                if Debug == 1:
                    logger.info("running to StartPos")

            if Cont:
                await _MoveAxis(Axis, EndPos)
                if Debug == 1:
                    logger.info("running to EndPos")

            if Cont:
                await _MoveAxis(Axis, StartPos)
                if Debug == 1:
                    logger.info("running to StartPos")

            idx = idx + 1
            
            if ((math.floor(idx / 10)) == (idx / 10)) or (idx == Iterations):
                HomeDev = await Axis.Home()
                if abs(HomeDev) > RefSwitchTolerance:
                    logger.error(f"Error: Homing deviation too big: {HomeDev} mm (Tolerance {RefSwitchTolerance} mm)")
                    Cont = False

    except Exception as e:
        logger.error(f"Error occured, Test stopped: {str(e)}")


# special version for Taurus Pipettor X and Y Test. Correct XY homing
async def _SingleAxisTestWHoming_XY(Axis, StartPos, EndPos, MinStepSize, Iterations):
    reserved = 0
    
    TotalDist = EndPos - StartPos
    Count1 = math.floor(TotalDist / MinStepSize)
    StepSize = TotalDist / Count1

    if Iterations > 1:
        logger.info(f"TotalDist: {TotalDist} mm")
        logger.info(f"Nr of steps per direction: {Count1}")
        logger.info(f"StepSize: {StepSize} mm")

    Cont = True
    OldPos = StartPos
    idx = 0
    
    reserved1, RefSwitchTolerance, reserved2 = await Axis.GetConfigParam((r"AxisConfig\RefSwitchToleranceUOM", reserved, 0))
    logger.info(f"RefSwitchTolerance: {RefSwitchTolerance} mm")

    try:
        while idx < Iterations and Cont:
            if Iterations > 1:
                logger.info_colour(Colour.LIGHTCYAN, f"iteration {idx + 1}")
            if not Cont:
                await _MoveAxis(Axis, StartPos)

            NewPos = StartPos
            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos + 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos - 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            if Cont:
                await _MoveAxis(Axis, EndPos)
                logger.info("running to EndPos")

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            idx = idx + 1
            
            if ((math.floor(idx / 10)) == (idx / 10)) or (idx == Iterations):
                logger.info("Homing for deviation testing:")
                HomeErr = await _homeXY()
                #HomeDev = await Axis.Home()
#                if abs(HomeDev) > RefSwitchTolerance:
#                   logger.error(f"Error: Homing deviation too big: {HomeDev} mm (Tolerance {RefSwitchTolerance} mm)")
                if HomeErr:
                    logger.error(f"Error: CoreXY Home Error")
                    Cont = False

    except Exception as e:
        logger.error(f"Error occured, Test stopped: {str(e)}")


async def _SingleAxisTestNew(Axis, StartPos, EndPos, MinStepSize, Iterations):
    TotalDist = EndPos - StartPos
    Count1 = math.floor(TotalDist / MinStepSize)
    StepSize = TotalDist / Count1

    if Iterations > 1:
        logger.info(f"TotalDist: {TotalDist} mm")
        logger.info(f"Nr of steps per direction: {Count1}")
        logger.info(f"StepSize: {StepSize} mm")

    Cont = True
    OldPos = StartPos
    idx = 0

    try:
        while idx < Iterations and Cont:
            if Iterations > 1:
                logger.warn(f"iteration {idx + 1}")
            if not Cont:
                await _MoveAxis(Axis, StartPos)

            NewPos = StartPos
            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos + 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos + (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            idx1 = 0

            while idx1 < Count1 and Cont:
                NewPos = NewPos - 0.1
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - 0.9
                if Cont:
                    await _MoveAxis(Axis, NewPos)

                NewPos = NewPos - (StepSize - 1)
                if Cont:
                    await _MoveAxis(Axis, NewPos)
                idx1 = idx1 + 1

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            if Cont:
                await _MoveAxis(Axis, EndPos)
                logger.info("running to EndPos")

            if Cont:
                await _MoveAxis(Axis, StartPos)
                logger.info("running to StartPos")

            idx = idx + 1

    except Exception as e:
        logger.error(f"Error occured, Test stopped: {str(e)}")


async def _MoveAxis(Axis, NewPos):
    MoveCount = 0
    TravelDist = 0
    OldPos = 0
    TravelDist = 0
    if MoveCount > 0:
        Dist = abs(NewPos - OldPos)
        TravelDist = TravelDist + Dist

    OldPos = NewPos
    MoveCount = MoveCount + 1

    if Debug == 1:
        logger.info_colour(Colour.LIGHTCYAN, f"Move to {NewPos}")

    await Axis.MoveAbs(NewPos)
    try:
        if EnSecondTry:
            logger.warn(f"Fault occured at pos {NewPos}. Try for a second time ...")
            await Axis.MoveAbs(NewPos)

            try:
                logger.info_colour(Colour.LIGHTGREEN, f"Pos {NewPos} worked for a second time, no fatal fault.")

            except Exception as e:
                logger.error(f"Fault occured for a second time, fatal fault: {str(e)}")

    except Exception as e:
            logger.error(f"Fault occured at pos {NewPos}: {str(e)} Retry disabled")


async def _homeXY():
    reserved = 0
    Error = None
    
    reserved1, RefSwitchToleranceX, reserved2 = await core.PipettorX.GetConfigParam((r"AxisConfig\RefSwitchToleranceUOM", reserved, 0))
    reserved1, RefSwitchToleranceY, reserved2 = await core.PipettorY.GetConfigParam((r"AxisConfig\RefSwitchToleranceUOM", reserved, 0))

    if Debug == 1:
        logger.info_colour(Colour.LIGHTCYAN, f"Home XY")
    
    HomeDevY = await core.PipettorY.Home()
    if abs(HomeDevY) > RefSwitchToleranceY:
        logger.error(f"Error: Homing deviation too big: {HomeDevY} mm (Tolerance {RefSwitchToleranceY} mm)")
        Error = True
        return Error
    HomeDevX = await core.PipettorX.Home()
    if abs(HomeDevX) > RefSwitchToleranceX:
        logger.error(f"Error: Homing deviation too big: {HomeDevX} mm (Tolerance {RefSwitchToleranceX} mm)")
        Error = True
        return Error
        
    return None



async def _initialize(*components):
    for component in components:
        await component.Initialize()
        logger.info_colour(Colour.LIGHTGREEN, f"{type(component).__name__} initialized")


async def InitPipettorXY():
    await _initialize(core.PipettorX)
    await _initialize(core.PipettorY)
    await _initialize(core.SideDoorLockFront)
    await _initialize(core.SideDoorLockBack)


async def InitHumidifier():
    await _initialize(core.HumidityControlFlap)


async def InitTransferGate():
    await _initialize(core.TransferGate)


async def InitPipZ():
    await _initialize(core.PipettorZ)
    await _initialize(core.ForbiddenAreaSensor)


async def InitPlunger():
    await _initialize(core.Plunger)


async def InitBFMover():
    await _initialize(core.BrightfieldMover)


async def HomeXY():
    logger.info("Homing XY:")
    HomeErr = await _homeXY()
    if HomeErr:
        logger.error(f"Error: CoreXY Home Error")
    else:
       logger.info("CoreXY homing finished")
    

async def HomeZ():
    logger.info("Homing PipZ:")
    await core.PipettorZ.Home()
    logger.info("PipZ homing finished")
    

async def HomeBF():
    logger.info("Homing Brightfield Mover:")
    await core.BrightfieldMover.Home()
   # await BrightfieldMover.MoveAbs(StartPos)
    logger.info_colour(Colour.LIGHTGREEN, "Brightfield Mover homing finished")


async def MoveXYtoZTestPos():
    logger.info("Move XY to PipZ Test Position:")
    await _MoveAxis(core.PipettorY, 200)
    await _MoveAxis(core.PipettorX, 450)
    logger.info("XY to PipZ moved to Test Position")
    

async def MoveXYBack():
    logger.info("Move XY back:")
    await _MoveAxis(core.PipettorX, 1)
    await _MoveAxis(core.PipettorY, 1)
    

async def TestPipettorXY(iterations):
    SpeedX = core.PipettorX.settings.MotorSpeed
    AccelX = core.PipettorX.settings.MotorAcceleration
    SpeedY = core.PipettorY.settings.MotorSpeed
    AccelY = core.PipettorY.settings.MotorAcceleration
    StartPosX = 1
    StartPosY = 1
    EndPosX = 470
    EndPosY = 470
    NrIterations = iterations
    Cont = True
    
    logger.info_colour(Colour.LIGHTGREEN, f"Test Pipettor XY Production Test Start:")
    logger.info(f"StartPosX: {StartPosX} StartPosY: {StartPosY}")
    logger.info(f"EndPosX: {EndPosX} EndPosY: {EndPosY}")
    logger.info(f"SpeedX: {SpeedX} SpeedY: {SpeedY}")
    logger.info(f"AccelX: {AccelX} AccelY: {AccelY}")
    logger.info(f"Nr. of Iterations: {NrIterations}")
    logger.info("\n")

    # Special Taurus Pipettor XY homing: first Y, then X!
    # caution: does not yet read "ForbiddenArea" sensor!
    logger.info("Homing XY:")
    HomeErr = await _homeXY()
    #HomeDev = await Axis.Home()
#                if abs(HomeDev) > RefSwitchTolerance:
#                   logger.error(f"Error: Homing deviation too big: {HomeDev} mm (Tolerance {RefSwitchTolerance} mm)")
    if HomeErr:
        logger.error(f"Error: CoreXY Home Error")
        Cont = False
#    await PipettorY.Home()
#   await PipettorX.Home()
    logger.info("Homing finished")

    # Run actual Test
    if Cont:
        await core.PipettorY.MoveAbs(200)
    if Cont:
        await _SingleAxisTestWHoming_XY(core.PipettorX, StartPosX, EndPosX, 30, NrIterations)
    if Cont:
        await core.PipettorX.MoveAbs(200)
    if Cont:
        await _SingleAxisTestWHoming_XY(core.PipettorY, StartPosY, EndPosY, 30, NrIterations)



    logger.info_colour(Colour.LIGHTGREEN, "Test Pipettor XY finished")


async def TestPipZ(iterations):
    StartPos = 1.0
    EndPos = 150.0
    # Iterations = int(iterations)
    NrIterations = iterations
    await _AxisTest(core.PipettorZ, StartPos, EndPos, NrIterations)
    await _SingleAxisTestWHoming(core.PipettorZ, StartPos, EndPos, 30, NrIterations)
    logger.info_colour(Colour.LIGHTGREEN, "Test Pipettor Z finished")


async def TestHumidifier(iterations):
    StartPos = 1.0
    EndPos = 85.0
    # NrIterations = NrIterationsGlobal
    NrIterations = iterations
    await _AxisTest(core.HumidityControlFlap, StartPos, EndPos, NrIterations)
    # await _SingleAxisTest(core.HumidityControlFlap, StartPos, EndPos, 15, NrIterations)
    await _SingleAxisTestWHoming(core.HumidityControlFlap, StartPos, EndPos, 15, NrIterations)
    logger.info_colour(Colour.LIGHTGREEN, "Test Humidifier finished")


async def TestTransferGate(iterations):
    StartPos = 1.0
    EndPos = 99.0
    MinStep = 20
    # NrIterations = NrIterationsGlobal
    NrIterations = iterations
    await _AxisTest(core.TransferGate, StartPos, EndPos, NrIterations)
    # await _SingleAxisTest(core.TransferGate, StartPos, EndPos, MinStep, NrIterations)
    await _SingleAxisTestWHoming(core.TransferGate, StartPos, EndPos, MinStep, NrIterations)
    logger.info_colour(Colour.LIGHTGREEN, "Test TransferGate finished")


async def TestPlunger(iterations):
    StartPos = -7.0
    EndPos = 14.0
#    NrIterations = NrIterationsGlobal
    NrIterations = iterations
    await _AxisTest(core.Plunger, StartPos, EndPos, NrIterations)
    await _SingleAxisTestWHoming(core.Plunger, StartPos, EndPos, 3, NrIterations)
    logger.info_colour(Colour.LIGHTGREEN, "Test Pipette Plunger finished")


async def TestBFMover(iterations):
    StartPos = 1.0
    EndPos = 37.0
#    NrIterations = NrIterationsGlobal
    NrIterations = iterations
    await _AxisTest(core.BrightfieldMover, StartPos, EndPos, NrIterations)
    await _SingleAxisTestWHoming(core.BrightfieldMover, StartPos, EndPos, 10, NrIterations)
    logger.info_colour(Colour.LIGHTGREEN, "Test BrightfieldMover finished")


async def TestBFInterlock():
    StartPos = 1.0
    EndPos = 37.0
    await core.BrightfieldMover.MoveAbs(StartPos)
    time.sleep(3)
    await core.BrightfieldMover.MoveAbs(EndPos)
    time.sleep(3)
    await core.BrightfieldMover.MoveAbs(StartPos)
    logger.info_colour(Colour.LIGHTGREEN, "Test Brightfield Interlock finished")
    

async def TestLocking():
    await core.SideDoorLockFront.On()
    await core.SideDoorLockBack.On()
    time.sleep(3)
    await core.SideDoorLockFront.Off()
    await core.SideDoorLockBack.Off()
    
async def ReadForbiddenAreaSensor():
    DIn = await core.ForbiddenAreaSensor.Get()
    logger.info(f"Forbidden Area Sensor: {DIn}")
